//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define macroRandom (rand() / (double)SHORT_MAX)
#define macroSigmoid(a) (1.0 / (1 + MathExp(-a)))
//+------------------------------------------------------------------+
#define def_Fast
//+------------------------------------------------------------------+
double _NAND[][3] {
                    {0, 0, 1},
                    {0, 1, 1},
                    {1, 0, 1},
                    {1, 1, 0},
                  };
//+------------------------------------------------------------------+
const uint nTrain = _NAND.Size() / 3;
const double eps = 1e-3;
//+------------------------------------------------------------------+
struct st_XOR
{
    double w0, w1, b, Err;
}_XOR;
//+------------------------------------------------------------------+
double Cost(const double w0, const double w1, const double b, const double &Train[][])
{
    double err;

    err = 0;
    for (uint c = 0; c < nTrain; c++)
        err += MathPow((macroSigmoid((Train[c][0] * w0) + (Train[c][1] * w1) + b) - Train[c][2]), 2);

    return err / nTrain;
}
//+------------------------------------------------------------------+
void OnStart()
{
    double ew0, ew1, eb;
    ulong count, it0, it1;

    Print("The Neuron - Tutor...");
    MathSrand(512);
    
    _XOR.w0 = (double)macroRandom;
    _XOR.w1 = (double)macroRandom;
    _XOR.b = (double)macroRandom;

    it0 = GetTickCount();

    for (count = 0; (count < ULONG_MAX) && ((_XOR.Err = Cost(_XOR.w0, _XOR.w1, _XOR.b, _NAND)) > eps); count++)
    {

        ew0 = ((Cost(_XOR.w0 + eps, _XOR.w1, _XOR.b, _NAND) - _XOR.Err) / eps);
        ew1 = ((Cost(_XOR.w0, _XOR.w1 + eps, _XOR.b, _NAND) - _XOR.Err) / eps);
        eb  = ((Cost(_XOR.w0, _XOR.w1, _XOR.b + eps, _NAND) - _XOR.Err) / eps);

        _XOR.w0 -= (ew0 * eps);
        _XOR.w1 -= (ew1 * eps);
        _XOR.b  -= (eb * eps);
    }

    it1 = GetTickCount();
    Print("Time: ", (it1 - it0) / 1000.0, " seconds.");
    PrintFormat("Interactions: %I64u", count);
    Print("NAND port Information: ");
    Print("w0: ", _XOR.w0, " w1: ", _XOR.w1, " bias: ", _XOR.b, " Error: ", _XOR.Err);

    Print("Testing the neuron...");
    for (uchar p0 = 0; p0 < 2; p0++)
        for (uchar p1 = 0; p1 < 2; p1++)
            PrintFormat("%d XOR %d IS %f", p0, p1,
                macroSigmoid((macroSigmoid((p1 * _XOR.w0) + (macroSigmoid((p0 * _XOR.w0) + (p0 * _XOR.w1) + _XOR.b) * _XOR.w1) + _XOR.b) * _XOR.w0) + 
                             (macroSigmoid((p0 * _XOR.w0) + (macroSigmoid((p1 * _XOR.w0) + (p1 * _XOR.w1) + _XOR.b) * _XOR.w1) + _XOR.b) * _XOR.w1) +
                             _XOR.b));

    Print("************************************");
}
//+------------------------------------------------------------------+